/*
  Audio Fader ++  (fade + volume + presets)
  - Quick buttons: 0 / -6 / -12 dB
  - Presets Save/Load
  - Selection Helpers: Name contains / 同じラベル色を選択（Shiftで置き換え↔加算を一時反転）
  - v2: UIレイアウト変更、フェード上限値を全体音量スライダーと連動
*/
(function(){
  var S="SI_AudioFader";
  function savePreset(n,o){try{for(var k in o)app.settings.saveSetting(S+"_"+n,k,String(o[k]));return true;}catch(e){alert(e);return false;}}
  function loadPreset(n,d){var r={};for(var k in d){var sec=S+"_"+n;if(app.settings.haveSetting(sec,k)){var v=app.settings.getSetting(sec,k);r[k]=(v==="true")?true:(v==="false")?false:(isNaN(Number(v))?v:Number(v));}else r[k]=d[k];}return r;}
  function comp(){return app.project.activeItem;}
  function audioProp(L){ return L.property("Audio") && L.property("Audio").property("Audio Levels"); }
  function forSel(fn,undo){ var c=comp(); if(!(c&&c instanceof CompItem)){ alert("コンポジションを選択してください。"); return; }
    var sel=c.selectedLayers; if(sel.length===0){ alert("操作したいオーディオレイヤーを選択してください。"); return; }
    app.beginUndoGroup(undo||"Audio Fader"); for(var i=0;i<sel.length;i++){ var a=audioProp(sel[i]); if(a) fn(sel[i],a); } app.endUndoGroup();
  }

  var w=new Window("palette","Audio Fader ++",undefined,{resizeable:true});
  w.orientation="column"; w.alignChildren="fill"; w.spacing=10; w.margins=12;

  // ==== Selection Helpers（Shift反転対応） ====
  var selPanel = w.add("panel", undefined, "Selection Helpers");
  selPanel.orientation="column"; selPanel.alignChildren="fill"; selPanel.margins=10; selPanel.spacing=8;

  var rowName = selPanel.add("group");
  rowName.add("statictext", undefined, "Name contains");
  var nameEt = rowName.add("edittext", undefined, ""); nameEt.characters=18;
  var btnByName = rowName.add("button", undefined, "Select by Name (Shift=Replace)");

  var rowOpts = selPanel.add("group");
  var btnSameLabel = rowOpts.add("button", undefined, "同じラベル色を選択 (Shift=Add)");

  function shouldReplace(defaultReplace){
      try{
          var ks = ScriptUI.environment.keyboardState;
          if (ks && ks.shiftKey) return !defaultReplace;
      }catch(e){}
      return defaultReplace;
  }

  btnByName.onClick=function(){
    var c=comp(); if(!(c&&c instanceof CompItem)) return;
    var q=nameEt.text||""; if(!q) return;
    var replace = shouldReplace(false); // 通常は加算
    if(replace){ for(var i=1;i<=c.numLayers;i++) c.layer(i).selected=false; }
    for(var i=1;i<=c.numLayers;i++){ var L=c.layer(i); if(String(L.name).indexOf(q)>=0) L.selected=true; }
  };
  btnSameLabel.onClick=function(){
    var c=comp(); if(!(c&&c instanceof CompItem)){ alert("コンポジションを開いてください。"); return; }
    var sel=c.selectedLayers; if(sel.length===0){ alert("まず基準にするレイヤーを1つ選択してください。"); return; }
    var idx=sel[0].label;
    for(var k=1;k<sel.length;k++){
        if(sel[k].label!==idx){
            if(!confirm("選択中のレイヤーに異なるラベル色があります。\n先頭レイヤーの色("+idx+")で検索します。続行しますか？")) return;
            break;
        }
    }
    var replace = shouldReplace(true); // 通常は置き換え
    if(replace){ for(var j=1;j<=c.numLayers;j++) c.layer(j).selected=false; }
    for(var i=1;i<=c.numLayers;i++){ var L=c.layer(i); if(L.label===idx) L.selected=true; }
  };
  // ==== /Selection Helpers ====

  // === 変更点 1: UIの順序を変更 ===
  // 全体音量パネルをフェードパネルの上に移動
  var volP=w.add("panel",undefined,"全体音量");
  volP.orientation="row"; volP.alignChildren=["left","center"]; volP.margins=10; volP.spacing=8;
  var sldr=volP.add("slider",undefined,0,-48,12); sldr.size=[150,20];
  var txt=volP.add("statictext",undefined,"0.0 dB"); txt.characters=7;
  var q0=volP.add("button",undefined,"0 dB"); var q6=volP.add("button",undefined,"-6 dB"); var q12=volP.add("button",undefined,"-12 dB");

  var fadeP=w.add("panel",undefined,"フェード設定（滑らか）");
  fadeP.orientation="column"; fadeP.alignChildren="left"; fadeP.margins=10; fadeP.spacing=6;
  var g1=fadeP.add("group"); var cbIn=g1.add("checkbox",undefined,"フェードイン"); cbIn.value=true; g1.add("statictext",undefined,"秒"); var etIn=g1.add("edittext",undefined,"1.0"); etIn.characters=5;
  var g2=fadeP.add("group"); var cbOut=g2.add("checkbox",undefined,"フェードアウト"); cbOut.value=true; g2.add("statictext",undefined,"秒"); var etOut=g2.add("edittext",undefined,"1.0"); etOut.characters=5;
  var btnApply=fadeP.add("button",undefined,"適用");
  // === /変更点 1 ===

  var btnClear=w.add("button",undefined,"オーディオキーフレームをクリア（0dBに）");

  var pr=w.add("panel",undefined,"Presets");
  pr.orientation="row"; pr.alignChildren=["left","center"]; pr.margins=10; pr.spacing=6;
  var btnSave=pr.add("button",undefined,"Save Preset"); var btnLoad=pr.add("button",undefined,"Load Preset");

  btnApply.onClick=function(){
    if(!cbIn.value && !cbOut.value){ alert("適用したいフェードのチェックボックスをONにしてください。"); return; }
    var inD=parseFloat(etIn.text), outD=parseFloat(etOut.text);
    if((cbIn.value && isNaN(inD)) || (cbOut.value && isNaN(outD))){ alert("有効な数値を秒数で入力してください。"); return; }

    // === 変更点 2: フェードの上限値をスライダーから取得 ===
    var peakVolume = sldr.value;
    // === /変更点 2 ===

    var cmd = app.findMenuCommandId("Easy Ease");
    forSel(function(L,a){
      while(a.numKeys>0) a.removeKey(1);
      var keys=[];

      // === 変更点 2: 取得した上限値をキーフレームに設定 ===
      if(cbIn.value){ var t0=L.inPoint, t1=Math.min(L.outPoint, L.inPoint+inD); keys.push(a.setValueAtTime(t0,[-96,-96])); keys.push(a.setValueAtTime(t1,[peakVolume,peakVolume])); }
      if(cbOut.value){ var t2=L.outPoint, t3=Math.max(L.inPoint, L.outPoint-outD); keys.push(a.setValueAtTime(t3,[peakVolume,peakVolume])); keys.push(a.setValueAtTime(t2,[-96,-96])); }
      // === /変更点 2 ===

      if(keys.length>0 && cmd!==0){
        for(var i=0;i<keys.length;i++) a.setSelectedAtKey(keys[i], true);
        app.executeCommand(cmd);
        for(var j=0;j<keys.length;j++) a.setSelectedAtKey(keys[j], false);
      }
    }, "オーディオフェード適用（イージーイーズ）");
  };

  sldr.onChanging=function(){ txt.text=(Math.round(this.value*10)/10).toFixed(1)+" dB"; };
  sldr.onChange=function(){
    var v=this.value; txt.text=(Math.round(v*10)/10).toFixed(1)+" dB";
    forSel(function(L,a){ while(a.numKeys>0) a.removeKey(1); a.setValue([v,v]); }, "全体音量を設定");
  };
  function setQuick(db){ sldr.value=db; txt.text=db.toFixed(1)+" dB"; forSel(function(L,a){ while(a.numKeys>0) a.removeKey(1); a.setValue([db,db]); }, "クイック音量 "+db+"dB"); }
  q0.onClick=function(){ setQuick(0); }; q6.onClick=function(){ setQuick(-6); }; q12.onClick=function(){ setQuick(-12); };

  btnClear.onClick=function(){ forSel(function(L,a){ while(a.numKeys>0) a.removeKey(1); a.setValue([0,0]); }, "オーディオ設定をクリア"); };

  btnSave.onClick=function(){
    var n=prompt("Preset name","MyAudioPreset"); if(!n) return;
    savePreset(n,{inOn:cbIn.value,outOn:cbOut.value,inSec:etIn.text,outSec:etOut.text});
    alert("Saved: "+n);
  };
  btnLoad.onClick=function(){
    var n=prompt("Preset to load","MyAudioPreset"); if(!n) return;
    var d={inOn:true,outOn:true,inSec:"1.0",outSec:"1.0"};
    var o=loadPreset(n,d);
    cbIn.value=!!o.inOn; cbOut.value=!!o.outOn; etIn.text=String(o.inSec); etOut.text=String(o.outSec);
  };

  w.center(); w.show();
})();